% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{xmu_match.arg}
\alias{xmu_match.arg}
\title{Select first item in list of options, while being flexible about choices.}
\usage{
xmu_match.arg(x, option_list, check = TRUE)
}
\arguments{
\item{x}{the value chosen (may be the default option list)}

\item{option_list}{A vector of valid options}

\item{check}{Whether to check that single items are in the list. Set false to accept abbreviations (defaults to TRUE)}
}
\value{
\itemize{
\item one validated option
}
}
\description{
Like a smart version of \code{\link[=match.arg]{match.arg()}}: Handles selecting parameter options when default is a list.
Unlike  \code{\link[=match.arg]{match.arg()}} \code{xmu_match.arg} allows items not in the list.
}
\examples{
option_list = c("default", "par.observed", "empirical")

xmu_match.arg("par.observed", option_list)
xmu_match.arg("allow me", option_list, check = FALSE)
xmu_match.arg(option_list, option_list)
option_list = c(NULL, "par.observed", "empirical")
 # fails with NULL!!!!!
xmu_match.arg(option_list, option_list)
option_list = c(NA, "par.observed", "empirical")
xmu_match.arg(option_list, option_list) # use NA instead
option_list = c(TRUE, FALSE, NA)
xmu_match.arg(option_list, option_list) # works with non character
# An example of checking a bad item and stopping
\dontrun{
xmu_match.arg("bad", option_list)
}
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=match.arg]{match.arg()}}
}

Other Get and set: \code{\link{umx_get_checkpoint}()},
  \code{\link{umx_get_options}()},
  \code{\link{umx_set_auto_plot}()},
  \code{\link{umx_set_auto_run}()},
  \code{\link{umx_set_checkpoint}()},
  \code{\link{umx_set_condensed_slots}()},
  \code{\link{umx_set_cores}()},
  \code{\link{umx_set_data_variance_check}()},
  \code{\link{umx_set_mvn_optimization_options}()},
  \code{\link{umx_set_optimizer}()},
  \code{\link{umx_set_plot_file_suffix}()},
  \code{\link{umx_set_plot_format}()},
  \code{\link{umx_set_separator}()},
  \code{\link{umx_set_silent}()},
  \code{\link{umx_set_table_format}()}, \code{\link{umx}}
}
\concept{Get and set}
