% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_fix_latents}
\alias{umx_fix_latents}
\title{umx_fix_latents}
\usage{
umx_fix_latents(model, latents = NULL, exogenous.only = TRUE, at = 1)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} to set}

\item{latents}{(If NULL then all latentVars)}

\item{exogenous.only}{only touch exogenous latents (default = TRUE)}

\item{at}{(Default = 1)}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Fix the variance of all, or selected, exogenous latents at selected values. This function adds a variance
to the factor if it does not exist.
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("fix_latents", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)#'
tmx_show(m1, what = "free", matrices = "S") # variance of g is not set
m1 = umx_fix_latents(m1)
tmx_show(m1, what = "free", matrices = "S") # variance of g is fixed at 1
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}()},
  \code{\link{umxLabel}()}, \code{\link{umxRAM2Ordinal}()},
  \code{\link{umxThresholdMatrix}()},
  \code{\link{umxValues}()},
  \code{\link{umx_fix_first_loadings}()},
  \code{\link{umx_get_bracket_addresses}()},
  \code{\link{umx_string_to_algebra}()}, \code{\link{umx}}
}
\concept{Advanced Model Building Functions}
