% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_add_variances}
\alias{umx_add_variances}
\title{umx_add_variances}
\usage{
umx_add_variances(model, add.to, values = NULL, free = NULL)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to add variances to}

\item{add.to}{= List of variables to create variance for}

\item{values}{= List of values (default = NULL)}

\item{free}{= List of variables to create variance for (default = NULL)}
}
\value{
- \code{\link{mxModel}}
}
\description{
Convenience function to save the user specifying mxPaths adding variance to each variable
}
\examples{
require(umx)
data(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
 manifestVars = names(demoOneFactor),
 latentVars = "g",
	mxPath(from = "g", to = names(demoOneFactor), values= .1),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
umx_show(m1, matrices = "S") # variables lack variance :-(
m1 = umx_add_variances(m1, add.to = names(demoOneFactor))
m1 = umx_add_variances(m1, add.to = "g", FALSE, 1)
umx_show(m1, matrices = "S") 
# Note: latent g has been treated like the manifests...
# umxFixLatents() will take care of this for you...
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
umxSummary(m1)
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{https://openmx.ssri.psu.edu}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}},
  \code{\link{umxLabel}}, \code{\link{umxLatent}},
  \code{\link{umxRAM2Ordinal}},
  \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}},
  \code{\link{umx_fix_first_loadings}},
  \code{\link{umx_fix_latents}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_string_to_algebra}}, \code{\link{umx}}
}
\concept{Advanced Model Building Functions}
