% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryGxE}
\alias{umxSummaryGxE}
\alias{umxSummary.MxModelGxE}
\title{umxSummaryGxE}
\usage{
umxSummaryGxE(model = NULL, digits = 2, xlab = NA,
  location = "topleft", separateGraphs = FALSE,
  file = getOption("umx_auto_plot"), returnStd = NULL, std = NULL,
  reduce = FALSE, CIs = NULL, report = c("markdown", "html"), ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxGxE}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{xlab}{label for the x-axis of plot}

\item{location}{default = "topleft"}

\item{separateGraphs}{default = F}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{std}{Whether to show the standardized model (not implemented! TRUE)}

\item{reduce}{Whether run and tabulate a complete model reduction...(Defaults to FALSE)}

\item{CIs}{Confidence intervals (FALSE)}

\item{report}{"1" = regular, "2" = add descriptive sentences; "html" = open a browser and copyable tables}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a Moderation model, as returned by \code{\link{umxGxE}}
}
\examples{
# The total sample has been subdivided into a young cohort, 
# aged 18-30 years, and an older cohort aged 31 and above.
# Cohort 1 Zygosity is coded as follows 1 == MZ females 2 == MZ males 
# 3 == DZ females 4 == DZ males 5 == DZ opposite sex pairs
require(umx)
data(twinData) 
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, zygosity == "MZFF", selVars)
dzData  = subset(twinData, zygosity == "DZMM", selVars)
# Exclude cases with missing Def
mzData <- mzData[!is.na(mzData[selDefs[1]]) & !is.na(mzData[selDefs[2]]),]
dzData <- dzData[!is.na(dzData[selDefs[1]]) & !is.na(dzData[selDefs[2]]),]
\dontrun{
m1 = umxGxE(selDVs = selDVs, selDefs = selDefs, dzData = dzData, mzData = mzData)
# Plot Moderation
umxSummaryGxE(m1)
umxSummaryGxE(m1, location = "topright")
umxSummaryGxE(m1, separateGraphs = FALSE)
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{umxGxE}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEnew}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCPold}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPnew}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
\concept{Twin Modeling Functions}
