% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_simplex_corner}
\alias{xmu_simplex_corner}
\title{Internal function to help building simplex models}
\usage{
xmu_simplex_corner(x, start = 0.9)
}
\arguments{
\item{x}{size of matrix, or an \code{\link{umxMatrix}} of which to free the bottom triangle.}

\item{start}{a default start value for the freed items.}
}
\value{
- \code{\link{umxMatrix}}
}
\description{
internal function to help building simplex models is a function which
}
\examples{
x = umxMatrix('test', 'Full', nrow = 4, ncol = 4)
xmu_simplex_corner(x, start = .9)
# See how we have a diag free, but offset 1-down?
umx_print( xmu_simplex_corner(x, start = .9)$values, zero=".")
}
\seealso{
- \code{\link{umxMatrix}}

Other xmu internal not for end user: \code{\link{umxModel}},
  \code{\link{umx}}, \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}},
  \code{\link{xmuLabel_RAM_Model}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmuPropagateLabels}},
  \code{\link{xmu_assemble_twin_supermodel}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_make_mxData}},
  \code{\link{xmu_make_top_twin_models}},
  \code{\link{xmu_safe_run_summary}},
  \code{\link{xmu_set_sep_from_suffix}},
  \code{\link{xmu_start_value_list}},
  \code{\link{xmu_starts}}
}
\concept{xmu internal not for end user}
