% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{loadings.MxModel}
\alias{loadings.MxModel}
\title{Extract factor loadings from an EFA (factor analysis).}
\usage{
\method{loadings}{MxModel}(x, ...)
}
\arguments{
\item{x}{A RAM model from which to get loadings.}

\item{...}{Other parameters (currently unused)}
}
\value{
- loadings matrix
}
\description{
loadings extracts the factor loadings from an EFA (factor analysis) model.
It behaves equivalently to stats::loadings, returning the loadings from an 
EFA (factor analysis). However it does not store the rotation matrix.
}
\examples{
myVars <- c("mpg", "disp", "hp", "wt", "qsec")
m1 = umxEFA(name = "test", factors = 2, data = mtcars[, myVars])
loadings(m1)
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{factanal}}, \code{\link{loadings}}

Other Reporting Functions: \code{\link{tmx_is.identified}},
  \code{\link{umxAPA}}, \code{\link{umxEval}},
  \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
