% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxSexLim.R
\name{umxSummarySexLim}
\alias{umxSummarySexLim}
\alias{umxSummary.MxModelSexLim}
\title{Shows a compact, publication-style, summary of a umx Sex Limitation model}
\usage{
umxSummarySexLim(model, digits = 2, file = getOption("umx_auto_plot"),
  comparison = NULL, std = TRUE, showRg = FALSE, CIs = TRUE,
  report = c("markdown", "html"), returnStd = FALSE,
  extended = FALSE, zero.print = ".", ...)
}
\arguments{
\item{model}{a \code{\link{umxSexLim}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = do not create plot output}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{std}{Whether to standardize the output (default = TRUE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{CIs}{Whether to show Confidence intervals if they exist (T)}

\item{report}{If "html", then open an html table of the results}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{zero.print}{How to show zeros (".")}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a fitted Cholesky model returned by \code{\link{umxSexLim}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. The report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for other umx models summary here: \code{\link{umxSummary}}.
}
\examples{
\dontrun{
# ======================================================
# = Beta: Should be good to use for Boulder/March 2020 =
# ======================================================

# =============================================
# = Run Qualitative Sex Differences ACE model =
# =============================================

# =========================
# = Load and Process Data =
# =========================
require(umx)
umx_set_optimizer("SLSQP")
data("us_skinfold_data")
# rescale vars
us_skinfold_data[, c('bic_T1', 'bic_T2')] = us_skinfold_data[, c('bic_T1', 'bic_T2')]/3.4
us_skinfold_data[, c('tri_T1', 'tri_T2')] = us_skinfold_data[, c('tri_T1', 'tri_T2')]/3
us_skinfold_data[, c('caf_T1', 'caf_T2')] = us_skinfold_data[, c('caf_T1', 'caf_T2')]/3
us_skinfold_data[, c('ssc_T1', 'ssc_T2')] = us_skinfold_data[, c('ssc_T1', 'ssc_T2')]/5
us_skinfold_data[, c('sil_T1', 'sil_T2')] = us_skinfold_data[, c('sil_T1', 'sil_T2')]/5

# Variables for Analysis
selDVs = c('ssc','sil','caf','tri','bic')
# Data for each of the 5 twin-type groups
mzmData = subset(us_skinfold_data, zyg == 1)
mzfData = subset(us_skinfold_data, zyg == 2)
dzmData = subset(us_skinfold_data, zyg == 3)
dzfData = subset(us_skinfold_data, zyg == 4)
dzoData = subset(us_skinfold_data, zyg == 5)

# ======================
# = Bivariate example =
# ======================

selDVs = c('tri','bic')
m1 = umxSexLim(selDVs = selDVs, sep = "_T", A_or_C = "A", tryHard = "yes",
	mzmData = mzmData, dzmData = dzmData, 
	mzfData = mzfData, dzfData = dzfData, 
	dzoData = dzoData
)
umxSummary(m1, file = NA);

# ===============
# = Switch to C =
# ===============
m1 = umxSexLim(selDVs = selDVs, sep = "_T", A_or_C = "C", tryHard = "yes",
	mzmData = mzmData, dzmData = dzmData, 
	mzfData = mzfData, dzfData = dzfData, 
	dzoData = dzoData
)
}
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxSexLim}}

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEold}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCPold}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPold}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySimplex}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
\concept{Reporting functions}
\concept{Twin Modeling Functions}
