% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotGxE}
\alias{plot.MxModel.GxE}
\alias{umxPlotGxE}
\title{umxPlotGxE}
\usage{
umxPlotGxE(x, xlab = NA, location = "topleft", separateGraphs = FALSE,
  ...)
}
\arguments{
\item{x}{A fitted \code{\link{umxGxE}} model to plot}

\item{xlab}{String to use for the x label (default = NA, which will use the variable name)}

\item{location}{Where to plot the legend (default = "topleft")
see ?legend for alternatives like bottomright}

\item{separateGraphs}{(default = FALSE)}

\item{...}{Optional additional parameters}
}
\value{
-
}
\description{
Plot GxE results (univariate environmental moderation of ACE components)
}
\examples{
require(umx)
data(twinData) 
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, zyg == 1, selVars)
dzData  = subset(twinData, zyg == 3, selVars)
m1 = umxGxE(selDVs = selDVs, selDefs = selDefs, 
 	dzData = dzData, mzData = mzData, dropMissing = TRUE)
plot(m1)
umxPlotGxE(x = m1, xlab = "SES", separateGraphs = TRUE, location = "topleft")
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxGxE}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotIP}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACEcov}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotIP}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}

