% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxReRun}
\alias{umxReRun}
\title{umxReRun}
\usage{
umxReRun(lastFit, update = NULL, regex = FALSE, free = FALSE, value = 0,
  freeToStart = NA, name = NULL, verbose = FALSE, intervals = FALSE,
  comparison = FALSE, dropList = "deprecated")
}
\arguments{
\item{lastFit}{The \code{\link{mxModel}} you wish to update and run.}

\item{update}{What to update before re-running. Can be a list of labels, a regular expression (set regex = TRUE) or an object such as mxCI etc.}

\item{regex}{Whether or not update is a regular expression (defaults to FALSE)}

\item{free}{The state to set "free" to for the parameters whose labels you specify (defaults to free = FALSE, i.e., fixed)}

\item{value}{The value to set the parameters whose labels you specify too (defaults to 0)}

\item{freeToStart}{Whether to update parameters based on their current free-state. free = c(TRUE, FALSE, NA), (defaults to NA - i.e, not checked)}

\item{name}{The name for the new model}

\item{verbose}{How much feedback to give}

\item{intervals}{Whether to run confidence intervals (see \code{\link{mxRun}})}

\item{comparison}{Whether to run umxCompare() after umxRun}

\item{dropList}{A list of strings. If not NA, then the labels listed here will be dropped (or set to the value and free state you specify)}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxReRun Is a convenience function to re-run an \code{\link{mxModel}}, optionally adding, setting, or dropping parameters.
The main value for umxReRun is compactness. So this one-liner drops a path labelled "Cs", and returns the updated model:
}
\details{
\code{fit2 = umxReRun(fit1, update = "Cs", name = "newModelName", comparison = TRUE)}

A powerful feature is regular expression. These let you drop collections of paths by matching patterns
fit2 = umxReRun(fit1, update = "C[sr]", regex = TRUE, name = "drop_Cs_andCr", comparison = TRUE)

If you're just starting out, you might find it easier to be more explicit. Like this:

fit2 = omxSetParameters(fit1, labels = "Cs", values = 0, free = FALSE, name = "newModelName")

fit2 = mxRun(fit2)
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
m2 = umxReRun(m1, update = "G_to_x1", name = "drop_X1")
umxSummary(m2); umxCompare(m1, m2)
# 1-line version including comparison
m2 = umxReRun(m1, update = "G_to_x1", name = "drop_X1", comparison = TRUE)
m2 = umxReRun(m1, update = "^G_to_x[3-5]", regex = TRUE, name = "no_G_to_x3_5", comp = TRUE)
m2 = umxReRun(m1, update = "G_to_x1", value = .2, name = "fix_G_x1", comp = TRUE)
m3 = umxReRun(m2, update = "G_to_x1", free = TRUE, name = "free_G_x1_again")
umxCompare(m3, m2)
}
\references{
- \url{http://github.com/tbates/umx}
}
\seealso{
Other Model Building Functions: \code{\link{umxCP}};
  \code{\link{umxDiagnose}}; \code{\link{umxGxE}};
  \code{\link{umxIP}}; \code{\link{umxLabel}};
  \code{\link{umxLatent}}; \code{\link{umxPath}};
  \code{\link{umxRAM}}; \code{\link{umxRun}};
  \code{\link{umxThresholdMatrix}};
  \code{\link{umxValues}};
  \code{\link{umx_fix_first_loadings}};
  \code{\link{umx_fix_latents}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

