% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxGxE}
\alias{umxGxE}
\title{umxGxE}
\usage{
umxGxE(name = "G_by_E", selDVs, selDefs, dzData, mzData, suffix = NULL,
  lboundACE = NA, lboundM = NA, dropMissingDef = FALSE)
}
\arguments{
\item{name}{The name of the model (defaults to "G_by_E")}

\item{selDVs}{The dependent variable (e.g. IQ)}

\item{selDefs}{The definition variable (e.g. socio economic status)}

\item{dzData}{The DZ dataframe containing the Twin 1 and Twin 2 DV and moderator}

\item{mzData}{The MZ dataframe containing the Twin 1 and Twin 2 DV and moderator}

\item{suffix}{(Optional) used to expand variable base names, i.e., "_T" makes var -> var_T1 and var_T2}

\item{lboundACE}{= numeric: If !is.na, then lbound the main effects at this value (default = NA)}

\item{lboundM}{= numeric: If !is.na, then lbound the moderators at this value (default = NA)}

\item{dropMissingDef}{whether to drop rows missing the definition variable (gives a warning) default = FALSE}
}
\value{
- GxE \code{\link{mxModel}}
}
\description{
Make a 2-group moderated ACE model
}
\examples{
# The total sample has been subdivided into a young cohort,
# aged 18-30 years, and an older cohort aged 31 and above.
# Cohort 1 Zygosity is coded as follows 1 == MZ females 2 == MZ males
# 3 == DZ females 4 == DZ males 5 == DZ opposite sex pairs
require(OpenMx)
data(twinData)
zygList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = zygList)
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, ZYG == "MZFF", selVars)
dzData  = subset(twinData, ZYG == "DZMM", selVars)
# Exclude cases with missing Def
mzData <- mzData[!is.na(mzData[selDefs[1]]) & !is.na(mzData[selDefs[2]]),]
dzData <- dzData[!is.na(dzData[selDefs[1]]) & !is.na(dzData[selDefs[2]]),]
m1 = umxGxE(selDVs = selDVs, selDefs = selDefs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
# Plot Moderation
umxSummaryGxE(m1)
umxSummary(m1, location = "topright")
umxSummary(m1, separateGraphs = FALSE)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{plot}()} and \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Model Building Functions: \code{\link{umxCP}};
  \code{\link{umxDiagnose}}; \code{\link{umxIP}};
  \code{\link{umxLabel}}; \code{\link{umxLatent}};
  \code{\link{umxPath}}; \code{\link{umxRAM}};
  \code{\link{umxReRun}}; \code{\link{umxRun}};
  \code{\link{umxThresholdMatrix}};
  \code{\link{umxValues}};
  \code{\link{umx_fix_first_loadings}};
  \code{\link{umx_fix_latents}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

