% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood-events.R,
%   R/neighbourhood-priorities.R, R/neighbourhood-team.R,
%   R/neighbourhoods-specific.R
\name{ukc_neighbourhood_events}
\alias{ukc_neighbourhood_events}
\alias{ukc_neighbourhood_priorities}
\alias{ukc_neighbourhood_team}
\alias{ukc_neighbourhood_specific}
\title{Specific Neighbourhood Events}
\usage{
ukc_neighbourhood_events(force, neighbourhood_id)

ukc_neighbourhood_priorities(force, neighbourhood_id)

ukc_neighbourhood_team(force, neighbourhood_id)

ukc_neighbourhood_specific(force, neighbourhood_id)
}
\arguments{
\item{force}{A string containing the name of the police force to return
neighbourhoods for. Must be specified, and is not case sensitive.}

\item{neighbourhood_id}{A string containing the ID of a given neighbourhood,
returned from \code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}. If missing, returns all neighbourhoods
for the specified police force, using \code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}.}
}
\value{
A tibble with data for a specific neighbourhood.
}
\description{
Data on a specific neighbourhood within a given police force area.
}
\details{
\code{ukpolice} contains the following functions for specific neighbourhoods:
\itemize{
\item \code{ukc_neighbourhood_specific}
\item \code{ukc_neighbourhood_team}
\item \code{ukc_neighbourhood_events}
\item \code{ukc_neighbourhood_priorities}
}
}
\examples{
\donttest{
events <- ukc_neighbourhood_events("dorset", "10-1")
}

\donttest{
priorities <- ukc_neighbourhood_team("dorset", "10-2")
}

\donttest{
people <- ukc_neighbourhood_team("dorset", "10-2")
}

\donttest{
# returns a specific neighbourood
places4 <- ukc_neighbourhood_specific("dorset", "10-1")

# returns all neighbourhoods as specific neighbourhood is unspecified.
places3 <- ukc_neighbourhood_specific("dorset")
}

}
\seealso{
\code{\link[=ukc_neighbourhood_boundary]{ukc_neighbourhood_boundary()}}

\code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}

\code{\link[=ukc_neighbourhood_boundary]{ukc_neighbourhood_boundary()}}

\code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}

\code{\link[=ukc_neighbourhood_boundary]{ukc_neighbourhood_boundary()}}

\code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}

\code{\link[=ukc_neighbourhood_location]{ukc_neighbourhood_location()}}

\code{\link[=ukc_neighbourhood_boundary]{ukc_neighbourhood_boundary()}}

\code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}

\code{\link[=ukc_neighbourhood_location]{ukc_neighbourhood_location()}}
}
