% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_download_and_export_items.R
\name{zotero_download_and_export_items}
\alias{zotero_download_and_export_items}
\title{Download and save all items in a public Zotero group}
\usage{
zotero_download_and_export_items(
  group,
  file,
  format = "bibtex",
  showKeys = TRUE
)
}
\arguments{
\item{group}{The group ID}

\item{file}{The filename to write to}

\item{format}{The format to export}

\item{showKeys}{Whether to show the keys}
}
\value{
The bibliography as a character vector
}
\description{
Download and save all items in a public Zotero group
}
\examples{
\dontrun{
tmpFile <- tempfile(fileext=".bib");
zotero_download_and_export_items(
  2425237,
  tmpFile
);
writtenBibliography <- readLines(tmpFile);
writtenBibliography[1:7];
}
}
