% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr.bootES.R
\name{pwr.bootES}
\alias{pwr.bootES}
\title{Estimate required sample size for accuracy in parameter estimation using bootES}
\usage{
pwr.bootES(data = data, ci.type = "bca", ..., w = 0.1,
  silent = TRUE)
}
\arguments{
\item{data}{The dataset, as you would normally supply to \code{\link[bootES:bootES]{bootES::bootES()}};
you will probably have to simulate this.}

\item{ci.type}{The estimation method; by default, the default of
\code{\link[bootES:bootES]{bootES::bootES()}} is used ('bca'), but this is changed to 'basic' if it
encounters problems.}

\item{...}{Other options for \code{\link[bootES:bootES]{bootES::bootES()}} (see that help page).}

\item{w}{The desired 'halfwidth' of the confidence interval.}

\item{silent}{Whether to provide a lot of information about progress
('FALSE') or not ('TRUE').}
}
\value{
A single numeric value (the sample size).
}
\description{
This function uses \code{\link[bootES:bootES]{bootES::bootES()}} to compute
}
\examples{
### To estimate a mean
x <- rnorm(500, mean=8, sd=3);
pwr.bootES(data.frame(x=x),
           R=500,
           w=.5);

### To estimate a correlation (the 'effect.type' parameter is
### redundant here; with two columns in the data frame, computing
### the confidence interval for the Pearson correlation is the default
### ehavior of bootES)
y <- x+rnorm(500, mean=0, sd=5);
cor(x, y);
requiredN <-
  pwr.bootES(data.frame(x=x,
                        y=y),
             effect.type='r',
             R=500,
             w=.2);
print(requiredN);
### Compare to parametric confidence interval
### based on the computed required sample size
confIntR(r = cor(x, y),
         N = requiredN);
### WIdth of obtained confidence interval
print(round(diff(as.numeric(confIntR(r = cor(x, y),
                            N = requiredN))), 2));
}
\references{
Kirby, K. N., & Gerlanc, D. (2013). BootES: An R package for bootstrap confidence
intervals on effect sizes. \emph{Behavior Research Methods, 45}, 905–927. \doi{10.3758/s13428-013-0330-5}
}
