% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_dependency_parsing.R
\name{cbind_dependencies}
\alias{cbind_dependencies}
\title{Add the dependency parsing information to an annotated dataset}
\usage{
cbind_dependencies(x, type = c("parent", "child"))
}
\arguments{
\item{x}{a data.frame or data.table as returned by \code{as.data.frame(udpipe_annotate(...))}}

\item{type}{currently only possible value is 'parent', indicating to add the information of the head_token_id to the dataset}
}
\value{
a data.frame/data.table in the same order of \code{x}
where the token/lemma/upos/xpos information of the parent (head dependency) is added to the data.frame. See the examples.
}
\description{
Annotated results of \code{udpipe_annotate} contain dependency parsing results which indicate
how each word is linked to another word and the relation between these 2 words.\cr
This information is available in the fields token_id, head_token_id and dep_rel which indicates how each token
is linked to the parent. The type of relation (dep_rel) is defined at 
\url{http://universaldependencies.org/u/dep/index.html}. 
For example in the text 'The economy is weak but the outlook is bright', the term economy is linked to weak
as the term economy is the nominal subject of weak. \cr
This function adds the parent information to the annotated data.frame.
}
\details{
Mark that the output which this function provides might possibly change in subsequent releases and is experimental.
}
\examples{
\dontrun{
udmodel <- udpipe_download_model(language = "english-ewt")
udmodel <- udpipe_load_model(file = udmodel$file_model)
x <- udpipe_annotate(udmodel, 
                     x = "The economy is weak but the outlook is bright")
x <- as.data.frame(x)
x[, c("token_id", "token", "head_token_id", "dep_rel")]
x <- cbind_dependencies(x, type = "parent")
nominalsubject <- subset(x, dep_rel \%in\% c("nsubj"))
nominalsubject <- nominalsubject[, c("dep_rel", "token", "token_parent")]
nominalsubject
}
}
