% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occu.R
\name{stan_occu}
\alias{stan_occu}
\title{Fit the MacKenzie et al. (2002) Occupancy Model}
\usage{
stan_occu(
  formula,
  data,
  prior_intercept_state = logistic(0, 1),
  prior_coef_state = logistic(0, 1),
  prior_intercept_det = logistic(0, 1),
  prior_coef_det = logistic(0, 1),
  prior_sigma = gamma(1, 1),
  log_lik = TRUE,
  ...
)
}
\arguments{
\item{formula}{Double right-hand side formula describing covariates of
detection and occupancy in that order}

\item{data}{A \code{\link{unmarkedFrameOccu}} object}

\item{prior_intercept_state}{Prior distribution for the intercept of the
state (occupancy probability) model; see \code{?priors} for options}

\item{prior_coef_state}{Prior distribution for the regression coefficients of
the state model}

\item{prior_intercept_det}{Prior distribution for the intercept of the
detection probability model}

\item{prior_coef_det}{Prior distribution for the regression coefficients of
the detection model}

\item{prior_sigma}{Prior distribution on random effect standard deviations}

\item{log_lik}{If \code{TRUE}, Stan will save pointwise log-likelihood values
in the output. This can greatly increase the size of the model. If
\code{FALSE}, the values are calculated post-hoc from the posteriors}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitOccu} object describing the model fit.
}
\description{
This function fits the single season occupancy model of
MacKenzie et al. (2002).
}
\examples{
\donttest{
data(frogs)
pferUMF <- unmarkedFrameOccu(pfer.bin)

#Add some covariates
siteCovs(pferUMF) <- data.frame(cov1=rnorm(numSites(pferUMF)))

#Fit model
(fm <- stan_occu(~1~cov1, pferUMF, chains=3, iter=300))
}

}
\references{
MacKenzie DI, Nichols JD, Lachman GB, Droege S, Royle JA,
 Langtimm CA. 2002. Estimating site occupancy rates when detection
 probabilities are less than one. Ecology 83: 2248-2255.
}
\seealso{
\code{\link{occu}}, \code{\link{unmarkedFrameOccu}}
}
