% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_define_cohorts_nm}
\alias{system_define_cohorts_nm}
\title{Define Cohorts from NONMEM Input File}
\usage{
system_define_cohorts_nm(cfg, DS = "DSNAME", col_ID = "ID",
  col_CMT = "CMT", col_DV = "DV", col_TIME = "TIME",
  col_AMT = "AMT", col_RATE = "RATE", col_EVID = "EVID",
  col_GROUP = NULL, filter = NULL, INPUTS = NULL, OBS = NULL)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{DS}{Name of the dataset loaded using \code{system_load_data}}

\item{col_ID}{Column of unique subject identifier}

\item{col_CMT}{Compartment column}

\item{col_DV}{Column with observations or \code{’.’} for input}

\item{col_TIME}{Column with system time of each record}

\item{col_AMT}{Infusion/dose amounts (these need to be in the same units specified in the system.txt file)}

\item{col_RATE}{Rate of infusion or \code{’.’} for bolus}

\item{col_EVID}{EVID (0 - observation, 1 dose)}

\item{col_GROUP}{Column name to use for defining similar cohorts when generating figures.}

\item{filter}{List used to filter the dataset or \code{NULL} if the whole dataset is to be used (see filter rules or  \code{\link{nm_select_records}} or a description of how to use this option)}

\item{INPUTS}{List mapping input information in the dataset to names used in the system.txt file}

\item{OBS}{List mapping obseravation information in the dataset to nams used in the system.txt file}
}
\value{
ubiquity system object with cohorts defined.
}
\description{
This function allows the user to define cohorts automatically
from a NONMEM dataset
}
\details{
\bold{NOTE: to use this function it is necessary that a timescale be define for the system time scale. For example, if the system time scale was days, something like the following is needed:}
\preformatted{<TS:days> 1}

Include all records in the dataset
\preformatted{filter = NULL}

Include only records matching the following filter
\preformatted{filter = list()
filter$COLNAME = c()}

Mapping information: 

The inputs mapping information (\code{INPUTMAP}) is alist with a field for each type of input:
input:
\itemize{
\item \code{bolus} List with a name for each bolus state in the dataset (\code{<B:?>}): each bolus name should have a \code{CMT_NUM} field indicating the compartment number for that state
\item \code{infusion_rates} List with a name for each rate in the dataset (\code{<R:?>}): each rate name should have a \code{CMT_NUM} field indicating the compartment number for that state
\item \code{covariates} List with for each covariate in the dataset (\code{<CV:?>}): each covariate name should have a \code{col_COV} indicating the column in the database that contains that covariate
}
From a coding perspective it looks like this:
\preformatted{INPUTMAP = list()
INPUTMAP$bolus$SPECIES$CMT_NUM            =  1
INPUTMAP$infusion_rates$RATE$CMT_NUM      =  1
INPUTMAP$covariates$CVNAME$col_COV        = 'CNAME'}

The observation mapping information (\code{OBSMAP}) is a list with elements for each output as
described in for system_define_cohort. Each output is a list with the following names:
\itemize{
 \item variance Variance model for this output
 \item CMT Compartment number mapping observations for this output
 \item output Name of the output (\code{<O>}) corresponding with the observations
 \item missing Value indicating a missing observation or \code{NULL}
}
From a coding perspective it looks like this:
\preformatted{OBSMAP = list()
OBSMAP$ONAME=list(variance     = 'PRED^2',
                 CMT          =  1,
                 output       = '<O>',
                 missing      =  NULL )}
}
\seealso{
Estimation vignette (\code{vignette("Estimation", package = "ubiquity")})
}
