% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_sam.R
\name{tile_sam}
\alias{tile_sam}
\title{Spectral Angle Mapper}
\usage{
tile_sam(SpectralPack, derivative = NULL)
}
\arguments{
\item{SpectralPack}{an object of class \code{\link[=SpectralPack-class]{SpectralPack}}.}

\item{derivative}{whether to apply the first (1) or second (2) derivative to preprocess the data before the algorithm is applied. Default NULL (It tells the program to not derivate).}
}
\value{
An object of class \code{\link[=SAM-class]{SAM}}.
}
\description{
Performs the Spectral Angle Mapper to match the \code{\link[=SpectralReference-class]{SpectralReference}} with yout readings (as \code{\link[=Tile-class]{Tile}}).
}
\examples{
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- tile_base_corr(x)
x <- wavealign(x, primpke)
x <- tile_sam(x)
}
\seealso{
For its application to mosaic images see \code{\link{mosaic_sam}}.
}
