% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eifs.R
\name{eif}
\alias{eif}
\title{Compute the Shift Parameter Estimate and the Efficient Influence Function}
\usage{
eif(
  Y,
  Qn,
  Hn,
  estimator = c("tmle", "onestep"),
  fluc_mod_out = NULL,
  Delta = rep(1, length(Y)),
  ipc_weights = rep(1, length(Y)),
  ipc_weights_norm = rep(1, length(Y))
)
}
\arguments{
\item{Y}{A \code{numeric} vector of the observed outcomes.}

\item{Qn}{An object providing the value of the outcome evaluated after
imposing a shift in the treatment. This object is passed in after being
constructed by a call to the internal function \code{est_Q}.}

\item{Hn}{An object providing values of the auxiliary ("clever") covariate,
constructed from the treatment mechanism and required for targeted minimum
loss-based estimation. This object object should be passed in after being
constructed by a call to the internal function \code{est_Hn}.}

\item{estimator}{The type of estimator to be fit, either \code{"tmle"} for
targeted maximum likelihood estimation or \code{"onestep"} for a one-step
estimator.}

\item{fluc_mod_out}{An object giving values of the logistic tilting model
for targeted minimum loss estimation. This type of object should be the
output of the internal routines to perform this step of the TML estimation
procedure, as given by \code{\link{fit_fluctuation}}.}

\item{Delta}{Indicator for missingness. Used for compatibility with the
routine to compute IPCW-TML estimates.}

\item{ipc_weights}{A \code{numeric} vector that gives inverse probability of
censoring weights for each observation. These are generated by invoking the
routines for estimating the censoring mechanism.}

\item{ipc_weights_norm}{A \code{numeric} vector of the weights described in
the previous argument. In this case, the weights are normalized.}
}
\value{
A \code{list} containing the parameter estimate, estimated variance
 based on the efficient influence function (EIF), the estimate of the EIF
 incorporating inverse probability of censoring weights, and the estimate of
 the EIF without the application of such weights.
}
\description{
Compute the Shift Parameter Estimate and the Efficient Influence Function
}
\details{
Estimate the value of the causal parameter alongside statistical
 inference for the parameter estimate based on the efficient influence
 function of the target parameter, which takes the following form:
 %D(P)(o) = H(a,w)(y - \bar{Q}(a,w)) + \bar{Q}(d(a,w)) - \psi(P)
}
