% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvma_3trt.R
\name{tvma_3trt}
\alias{tvma_3trt}
\title{Time Varying Mediation Function: Continuous Outcome and Three Treatment Groups}
\usage{
tvma_3trt(
  T1,
  T2,
  t.seq,
  mediator,
  outcome,
  t.est = t.seq,
  plot = FALSE,
  CI = "boot",
  replicates = 1000,
  grpname = "T",
  verbose = FALSE
)
}
\arguments{
\item{T1}{a vector indicating assignment to treatment 1}

\item{T2}{a vector indicating assignment to treatment 2}

\item{t.seq}{a vector of time points for each observation}

\item{mediator}{matrix of mediator values in wide format}

\item{outcome}{matrix of outcome values in wide format}

\item{t.est}{a vector of time points at which to make the estimation. 
Default = t.seq. (OPTIONAL ARGUMENT)}

\item{plot}{TRUE or FALSE for plotting mediation effect. 
Default = "FALSE". (OPTIONAL ARGUMENT)}

\item{CI}{"none" or "boot" method of deriving confidence intervals. 
Default = "boot". (OPTIONAL ARGUMENT)}

\item{replicates}{number of replicates for bootstrapping confidence intervals. 
Default = 1000. (OPTIONAL ARGUMENT)}

\item{grpname}{name of the treatment arms (exposure groups) to be displayed in
the results. Default = "T". (OPTIONAL ARGUMENT)}

\item{verbose}{TRUE or FALSE for printing results to screen. 
Default = "FALSE". (OPTIONAL ARGUMENT)}
}
\value{
\item{hat.alpha1}{estimated Treatment 1 effect on mediator}

\item{CI.lower.alpha1}{CI lower limit for estimated coefficient hat.alpha1}

\item{CI.upper.alpha1}{CI upper limit for estimated coefficient hat.alpha1}

\item{hat.alpha2}{estimated Treatment 2 effect on mediator}

\item{CI.lower.alpha2}{CI lower limit for estimated coefficient hat.alpha2}

\item{CI.upper.alpha2}{CI upper limit for estimated coefficient hat.alpha2}

\item{hat.gamma1}{estimated Treatment 1 direct effect on outcome}

\item{CI.lower.gamma1}{CI lower limit for estimated coefficient hat.gamma1}

\item{CI.upper.gamma1}{CI upper limit for estimated coefficient hat.gamma1}

\item{hat.gamma2}{estimated Treatment 2 direct effect on outcome}

\item{CI.lower.gamma2}{CI lower limit for estimated coefficient hat.gamma2}

\item{CI.upper.gamma2}{CI upper limit for estimated coefficient hat.gamma2}

\item{hat.tau1}{estimated Treatment 1 total effect on outcome}

\item{CI.lower.tau1}{CI lower limit for estimated coefficient hat.tau1}

\item{CI.upper.tau1}{CI upper limit for estimated coefficient hat.tau1}

\item{hat.tau2}{estimated Treatment 2 total effect on outcome}

\item{CI.lower.tau2}{CI lower limit for estimated coefficient hat.tau2}

\item{CI.upper.tau2}{CI upper limit for estimated coefficient hat.tau2}

\item{hat.beta}{estimated mediator effect on outcome}

\item{CI.lower.beta}{CI lower limit for estimated coefficient hat.beta}

\item{CI.upper.beta}{CI upper limit for estimated coefficient hat.beta}

\item{hat.mediation1}{time varying mediation effect for Treatment 1 on outcome}

\item{SE_MedEff1}{estimated standard errors of hat.mediation1}

\item{CI.upper.T1}{CI upper limit for hat.mediation1}

\item{CI.lower.T1}{CI lower limit for hat.mediation1}

\item{hat.mediation2}{time varying mediation effect for Treatment 2 on outcome}

\item{SE_MedEff2}{estimated standard errors of hat.mediation2}

\item{CI.upper.T2}{CI upper limit for hat.mediation2}

\item{CI.lower.T2}{CI lower limit for hat.mediation2}
}
\description{
Function to estimate the time-varying mediation effect and bootstrap standard 
errors for three treatment groups and a continuous outcome.
}
\section{Plot Returns}{

\enumerate{
\item{\code{plot1_a1 }}{plot for hat.alpha1 with CIs over t.est}
\item{\code{plot2_a2 }}{plot for hat.alpha2 with CIs over t.est}
\item{\code{plot3_g1 }}{plot for hat.gamma1 with CIs over t.est}
\item{\code{plot4_g2 }}{plot for hat.gamma2 with CIs over t.est}
\item{\code{plot5_t1 }}{plot for hat.tau1 with CIs over t.est}
\item{\code{plot6_t2 }}{plot for hat.tau2 with CIs over t.est}
\item{\code{plot7_b }}{plot for hat.beta with CIs over t.est}
\item{\code{MedEff_T1 }}{plot for hat.mediation1 over t.est}
\item{\code{MedEff_T2 }}{plot for hat.mediation2 over t.est}
\item{\code{MedEff_CI_T1 }}{plot for hat.mediation1 with CIs over t.est}
\item{\code{MedEff_CI_T2 }}{plot for hat.mediation2 with CIs over t.est}
}
}

\examples{
\dontrun{data(smoker)

# GENERATE WIDE FORMATTED MEDIATORS
mediator <- LongToWide(smoker$SubjectID,
                        smoker$timeseq, 
                        smoker$NegMoodLst15min)

# GENERATE WIDE FORMATTED OUTCOMES
outcome <- LongToWide(smoker$SubjectID,
                      smoker$timeseq,
                      smoker$cessFatig)

# GENERATE TWO BINARY TREATMENT VARIABLES
NRT1 <- as.numeric(unique(smoker[,c("SubjectID","varenicline")])[,2])-1
NRT2 <- as.numeric(unique(smoker[,c("SubjectID","comboNRT")])[,2])-1

# GENERATE A VECTOR OF UNIQUE TIME POINTS
t.seq <- sort(unique(smoker$timeseq))

# COMPUTE TIME VARYING MEDIATION ANALYSIS USING BOOTSTRAPPED CONFIDENCE INTERVALS
results <- tvma_3trt(NRT1, NRT2, t.seq, mediator, outcome)

# COMPUTE TIME VARYING MEDIATION ANALYSIS FOR SPECIFIED POINTS IN TIME USING 250 REPLICATES
results <- tvma_3trt(NRT1, NRT2, t.seq, mediator, outcome,
                     t.est = c(0.2, 0.4, 0.6, 0.8),
                     replicates = 250)}

}
\references{
\enumerate{
\item{Fan, J. and Gijbels, I. (1996). Local polynomial modelling and its 
      applications: monographs on statistics and applied probability 66. 
      CRC Press.}
\item{Fan, J. and Zhang, W. (1999). Statistical estimation in varying 
      coefficient models. The Annals of Statistics, 27, 1491-1518.}
\item{Fan, J. and Zhang, W. (2000). Two-step estimation of functional linear 
      models with applications to longitudinal data. Journal of the Royal 
      Statistical Society: Series B (Statistical Methodology), 62, 303-322.}
\item{Cai, X., Piper, M. E., Li, R., & Coffman, D. L. (2020). 
      Estimation and inference for the mediation effect in a time-varying 
      mediation model. <https://arxiv.org/abs/2008.11797>}
\item{Baker, T. B., Piper, M. E., Stein, J. H., Smith, S. S., Bolt, D. M., 
      Fraser, D. L., & Fiore, M. C. (2016). Effects of nicotine patch vs 
      varenicline vs combination nicotine replacement therapy on smoking 
      cessation at 26 weeks: A randomized clinical trial. JAMA, 315(4), 
      371-379.}
\item{Efron, B. and Tibshirani, R. (1986). Bootstrap methods for standard 
      errors, confidence intervals, and other measures of statistical accuracy. 
      Statistical Science, 1, 54-75.}
}
}
