% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvRE.R
\name{tvRE}
\alias{tvRE}
\alias{tvRE.matrix}
\alias{tvRE.tvplm}
\title{Time-Varying Random Effects Estimation}
\usage{
tvRE(x, ...)

\method{tvRE}{matrix}(
  x,
  y,
  z = NULL,
  ez = NULL,
  bw,
  Sigma = NULL,
  neq,
  obs,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian"),
  ...
)

\method{tvRE}{tvplm}(x, ...)
}
\arguments{
\item{x}{An object used to select a method.}

\item{...}{Other arguments passed to specific methods.}

\item{y}{A vector with dependent variable.}

\item{z}{A vector with the variable over which coefficients are smooth over.}

\item{ez}{(optional) A scalar or vector with the smoothing values. If 
values are included then the vector z is used.}

\item{bw}{A numeric vector with the bandwidth.}

\item{Sigma}{NULL (default) or a matrix of size obs x obs..}

\item{neq}{A scalar with the number of equations}

\item{obs}{A scalar with the number of time observations}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant
or "ll" for local linear.}

\item{tkernel}{A character, either "Triweight" (default), "Epa" or "Gaussian" kernel function.}
}
\value{
\code{tvRE} returns a list containing:
\item{coefficients}{A vector of length obs, number of observations with
the time-varying estimates.}
\item{fitted}{A vector of length obs with the fited values from the estimation.}
\item{residuals}{A vector of length obs with the residuals from the estimation.}
\item{alpha}{A vector of length neq with the fixed effects.}
}
\description{
\code{tvRE} estimate time-varying coefficient of a random effects 
panel data model using kernel smoothing.
}
