% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvIRF.R
\name{tvIRF}
\alias{tvIRF}
\alias{tvirf-class}
\alias{tvirf.}
\title{Time-Varying Impulse Response Function}
\usage{
tvIRF(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  ortho.cov = c("tv", "const"),
  bw.cov = NULL,
  cumulative = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{tvvar}.}

\item{impulse}{A character vector of the impulses, default is all variables.}

\item{response}{A character vector of the responses, default is all variables.}

\item{n.ahead}{Integer specifying the steps.}

\item{ortho}{Logical, if TRUE (the default) the orthogonalised IRF is computed.}

\item{ortho.cov}{A character indicating if the covariance matrix for the 
orthogonal tvIRF should be estimated as a constant or time varying. Either 
'const' or 'tv' (default). This parameter is used only when ortho = TRUE.}

\item{bw.cov}{A scalar (optional) with the bandwidth to estimate the errors
variance-covariance matrix. If left NULL, it is estimated.}

\item{cumulative}{Logical, if TRUE the cumulated impulse response 
coefficients are computed. Default is FALSE.}

\item{...}{Other parameters passed to specific methods.}
}
\value{
\code{tvIRF} returns and object of class \code{tvirf} with the 
following components:
\item{irf}{A list of length the number of impulse variable(s). Each element
of the list is an array of dim = c(obs x number 
of response variables x n.ahead).}
\item{Lower}{A list of length the number of impulse variable(s), containing
 the lower confidence line, if calculated.}
\item{Upper}{A list of length the number of impulse variable(s), containing
 the upper confidence line, if calculated.}
\item{response}{A character, a number of a vector with the names or 
positions of the response(s) variable(s).}
\item{impulse}{A character, a number of a vector with the names or 
positions of the impulse(s) variable(s).}
\item{x}{A object of class \code{tvvar}}.
\item{n.ahead}{Number of ahead impulse response functions.}
\item{ortho}{Logical, orthogonal or not impuluse response function.}
\item{ortho.cov}{Character, either 'const' or 'tv' (default). This 
parameter is used when the orthogonal TVIRF is calculated. The default 
is using an error time-varying variance-covariance.}
\item{bw.cov}{A scalar with the bandwidth to estimate the errors 
variance-covariance matrix. If NULL, it is calculated by cross-validation.}
\item{cumulative}{Logical, if TRUE the cumulated impulse response 
coefficients are computed. Default is FALSE.}
}
\description{
Computes the time-varying impulse response coefficients of an object 
of class \code{tvvar},  obtained with function \code{tvVAR} for \code{n.ahead} steps.
}
\examples{
\dontrun{
##Inflation rate, unemployment rate and treasury bill 
##interest rate for the US as in Primiceri (2005). 
data(usmacro, package = "bvarsv")
model.tvVAR <- tvVAR(usmacro, p = 4, type = "const")

##Estimate a the tvIRF with time-varying covariance function
model.tvIRF <- tvIRF(model.tvVAR)

##Cumulative impulse response function
model.tvIRF2 <- tvIRF(model.tvVAR, cumulative = TRUE)
}

}
\seealso{
\code{\link{bw}}, \code{\link{tvVAR}}, \code{\link{confint}}, 
\code{\link{plot}}, \code{\link{print}} and \code{\link{summary}}
}
