% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_tuls.r
\name{tuls}
\alias{tuls}
\title{Spectral analysis of time-uncertain time series using Lomb-Scargle method}
\usage{
tuls(y, ti.mu, ti.sd, n.sim = 1000, ...)
}
\arguments{
\item{y}{A vector of observations.}

\item{ti.mu}{A vector of estimates of timings of observations.}

\item{ti.sd}{A vector of standard deviations of timings.}

\item{n.sim}{A number of simulations.}

\item{...}{list of optional parameters: \cr
- oversamlping parameter: the default value of ofac=4. \cr
- confidence interval: the default value is CI=0.99. \cr
- number of simulations: the default vale set to n.sim=1000.}
}
\description{
\code{tuls} computes multiple power estimates using the Lomb-Scargle algorithm and simulated realizations of
uncorrelated timings of observations. Timings are simulated with normal distribution \emph{ti~N(ti.mu,ti.sd)},
and sorted in ascending order to ensure non-overlapping feature of observations.
}
\examples{
#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=50,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Run multiple Lomb-Scargle periodograms (optional parameters are listed in brackets):
TULS=tuls(y=y,ti.mu=ti.mu,ti.sd=ti.sd,n.sim=500)     # (ofac, CI).

#3. Plot the Lomb-Scargle periodograms:
plot(TULS)

#4. Obtain list of frequencies for which spectral power exceeds confidence interval:
summary(TULS)
}
\references{
\url{https://en.wikipedia.org/wiki/Least-squares_spectral_analysis}
}
\seealso{
\url{https://CRAN.R-project.org/package=Bchron}
}
