% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{control_grid}
\alias{control_grid}
\alias{control_resamples}
\title{Control aspects of the grid search process}
\usage{
control_grid(
  verbose = FALSE,
  allow_par = TRUE,
  extract = NULL,
  save_pred = FALSE,
  pkgs = NULL,
  save_workflow = FALSE
)

control_resamples(
  verbose = FALSE,
  allow_par = TRUE,
  extract = NULL,
  save_pred = FALSE,
  pkgs = NULL,
  save_workflow = FALSE
)
}
\arguments{
\item{verbose}{A logical for logging results as they are generated. Despite
this argument, warnings and errors are always shown. If using a dark IDE
theme, some logging messages might be hard to see. If this is the case,
try setting the \code{tidymodels.dark} option with
\code{options(tidymodels.dark = TRUE)} to print lighter colors.}

\item{allow_par}{A logical to allow parallel processing (if a parallel
backend is registered).}

\item{extract}{An optional function with at least one argument (or \code{NULL})
that can be used to retain arbitrary objects from the model fit object,
recipe, or other elements of the workflow.}

\item{save_pred}{A logical for whether the out-of-sample predictions should
be saved for each model \emph{evaluated}.}

\item{pkgs}{An optional character string of R package names that should be
loaded (by namespace) during parallel processing.}

\item{save_workflow}{A logical for whether the workflow should be appended
to the output as an attribute.}
}
\description{
Control aspects of the grid search process
}
\details{
For \code{extract}, this function can be used to output the model object, the
recipe (if used), or some components of either or both. When evaluated, the
function's sole argument has a fitted workflow If the formula method is used,
the recipe element will be \code{NULL}.

The results of the \code{extract} function are added to a list column in the
output called \code{.extracts}. Each element of this list is a tibble with tuning
parameter column and a list column (also called \code{.extracts}) that contains
the results of the function. If no extraction function is used, there is no
\code{.extracts} column in the resulting object. See \code{\link[=tune_bayes]{tune_bayes()}} for more
specific details.

Note that for \code{\link[=collect_predictions]{collect_predictions()}}, it is possible that each row of the
original data point might be represented multiple times per tuning
parameter. For example, if the bootstrap or repeated cross-validation are
used, there will be multiple rows since the sample data point has been
evaluated multiple times. This may cause issues when merging the predictions
with the original data.

\code{\link[=control_resamples]{control_resamples()}} is an alias for \code{\link[=control_grid]{control_grid()}} and is meant to be
used with \code{\link[=fit_resamples]{fit_resamples()}}.
}
