% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_caption_tracks.R
\name{list_caption_tracks}
\alias{list_caption_tracks}
\title{Get Captions of a Video}
\usage{
list_caption_tracks(part = "snippet", video_id = NULL, lang = "en",
  id = NULL, simplify = TRUE, ...)
}
\arguments{
\item{part}{Caption resource requested. Required. Comma separated list of one or more of the 
following: \code{id, snippet}. e.g., "id, snippet", "id" Default: \code{snippet}.}

\item{video_id}{ID of the video whose captions are requested. Required. No default.}

\item{lang}{Language of the caption; required; default is english ("en")}

\item{id}{comma-separated list of IDs that identify the caption resources that should be retrieved; optional; string}

\item{simplify}{Boolean. Default is TRUE. When TRUE, and part is \code{snippet}, a data.frame is returned}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
list of caption tracks. When \code{simplify} is \code{TRUE}, a \code{data.frame} is returned with 
following columns: \code{videoId, lastUpdated, trackKind, language, name, audioTrackType, isCC,
isLarge, isEasyReader, isDraft, isAutoSynced, status, id} (caption id)
}
\description{
Get Captions of a Video
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

list_caption_tracks(video_id="yJXTXN4xrI8")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/captions/list}
}
