% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_gminmax.R
\name{ts_norm_gminmax}
\alias{ts_norm_gminmax}
\title{Time Series Global Min-Max}
\usage{
ts_norm_gminmax(outliers = outliers_boxplot())
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}
}
\value{
returns a \code{ts_norm_gminmax} object.
}
\description{
Rescales data, so the minimum value is mapped to 0 and the maximum value is mapped to 1.
}
\examples{
# time series to normalize
library(daltoolbox)
data(tsd)

# convert to sliding windows
ts <- ts_data(tsd$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_gminmax()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
