% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{has_gaps}
\alias{has_gaps}
\title{Does a tsibble have implicit gaps in time?}
\usage{
has_gaps(.data, .full = FALSE, .name = ".gaps")
}
\arguments{
\item{.data}{A tsibble.}

\item{.full}{\itemize{
\item \code{FALSE} inserts \code{NA} for each keyed unit within its own period.
\item \code{TRUE} fills \code{NA} over the entire time span of the data (a.k.a. fully balanced panel).
\item \code{start()} pad \code{NA} to the same starting point (i.e. \verb{min(<index>)}) across units.
\item \code{end()} pad \code{NA} to the same ending point (i.e. \verb{max(<index>)}) across units.
}}

\item{.name}{Strings to name new columns.}
}
\value{
A tibble contains "key" variables and new column \code{.gaps} of \code{TRUE}/\code{FALSE}.
}
\description{
Does a tsibble have implicit gaps in time?
}
\examples{
harvest <- tsibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2013),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = fruit, index = year
)
has_gaps(harvest)
has_gaps(harvest, .full = TRUE)
has_gaps(harvest, .full = start())
has_gaps(harvest, .full = end())
}
\seealso{
Other implicit gaps handling: 
\code{\link{count_gaps}()},
\code{\link{fill_gaps}()},
\code{\link{scan_gaps}()}
}
\concept{implicit gaps handling}
