% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvers.R
\name{nloptr_fast_options}
\alias{nloptr_fast_options}
\alias{nloptr_options}
\alias{nloptr_global_options}
\title{Default options for nloptr solver}
\usage{
nloptr_fast_options(
  trace = FALSE,
  xtol_rel = 1e-14,
  maxeval = 1000,
  xtol_abs = 1e-12
)

nloptr_global_options(
  trace = FALSE,
  xtol_rel = 1e-14,
  maxeval = 1000,
  xtol_abs = 1e-12
)
}
\arguments{
\item{trace}{equivalent to option \dQuote{print_level} for nloptr. High values results in
more details.}

\item{xtol_rel}{Stop when an optimization step (or an estimate of the optimum) changes
every parameter by less than xtol_rel multiplied by the absolute value of the parameter.}

\item{maxeval}{top when the number of function evaluations exceeds maxeval.
This is not a strict maximum: the number of function evaluations may exceed
maxeval slightly, depending upon the algorithm}

\item{xtol_abs}{is a vector of length n (the number of elements in x) giving the
tolerances: stop when an optimization step (or an estimate of the optimum)
changes every parameter x(i) by less than xtol_abs(i).}
}
\value{
A list with options which can be passed to the solver.
}
\description{
Default options for nloptr solver
}
\details{
These as just a set of pre-created defaults which work well, particularly
the \dQuote{nloptr_fast_options} which uses an SQP solver. nloptr has many other
solvers and combination of solvers which can be used. However, keep in mind that the solver
must accept analytic derivatives as well as nonlinear inequality constraints.
}
