% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolling_origin.R
\name{rolling_origin}
\alias{rolling_origin}
\title{Assessing forecasting accuracy with rolling origin}
\usage{
rolling_origin(grnnf, h = NULL, rolling = TRUE)
}
\arguments{
\item{grnnf}{A \code{grnnForecast} object.}

\item{h}{A positive integer. The forecast horizon. If \code{NULL} (the
default) the prediction horizon of the \code{gnnForecast} object is used.}

\item{rolling}{A logical. If \code{TRUE} (the default), forecasting horizons
from 1 to \code{h} are used. Otherwise, only horizon \code{h} is used.}
}
\value{
A list containing at least the following fields:

\item{\code{test_sets}}{a matrix containing the test sets used in the
evaluation. Every row contains a different test set.}
\item{\code{predictions}}{The predictions for the test sets.}
\item{\code{errors}}{The errors for the test sets.}
\item{\code{global_accu}}{Different measures of accuracy applied to all the
errors.} \item{\code{h_accu}}{Different measures of accuracy applied to all
the errors for every forecasting horizon.}
}
\description{
It uses the model and the time series associated with a \code{grnnForecast}
object to assess the forecasting accuracy of the model using the last
\code{h} values of the time series to build test sets applying a rolling
origin evaluation.
}
\details{
This function assesses the forecast accuracy of the model used by the
\code{grnnForecast} object. It uses \code{h} different test and training
sets. The first test set consists of the last \code{h} values of the time
series (the training set is formed by the previous values). The next test set
consists of the last \eqn{h - 1} values of the time series and so on (the
last test set is formed by the last value of the time series).
}
\examples{
pred <- grnn_forecasting(UKgas, h = 4, lags = 1:4)
ro <- rolling_origin(pred)
print(ro$global_accu)
}
