\name{tsfa-package}
\alias{tsfa-package}
\alias{tsfa.Intro}
\docType{package}

\title{Time Series Factor Analysis (TSFA)}

\description{TSFA extends standard factor analysis (FA) to 
time series data. Rotations methods can be applied as in FA.
A dynamic model of the factors is not assumed, but could be 
estimated separately using the extracted factors.
}

\details{
\tabular{ll}{
Package: \tab tsfa\cr
Depends: \tab R (>= 2.0.0), GPArotation, setRNG (>= 2004.4-1), tframe (>=
2006.1-1),\cr
         \tab dse1 (>= 2006.1-1), dse2 (>= 2006.1-1)\cr
Suggests: \tab CDNmoney\cr
License: \tab GPL Version 2.\cr
URL: \tab http://www.bank-banque-canada.ca/pgilbert\cr
}

The main functions are:
\preformatted{
DstandardizedLoadings   Extract standardized loadings from an object
loadings                Extractloadings from an object
estTSF.ML               Estimate a time series factor model
factors                 Extract time series factors from an object
FAmodelFitStats         Various fit statistics.
simulate                Simulate a time series factor model
summary                 Summary methods for \pkg{tsfa} objects
tfplot                  Plot methods for \pkg{tsfa} objects
TSFmodel                Construct a time series factor model
}

An overview of how to use the package is available in the vignette
\code{tsfa} (source, pdf).
}

\author{
Paul Gilbert <pgilbert@bank-banque-canada.ca> and
Erik Meijer  <e.meijer@eco.rug.nl>

Maintainer: Paul Gilbert <pgilbert@bank-banque-canada.ca>  
}
\references{
  Gilbert, Paul D. and Meijer, Erik (2005)
  Time Series Factor Analaysis with an Application to Measuring Money.
  Research Report 05F10, University of Groningen, SOM Research School.
  Available from \url{http://som.eldoc.ub.rug.nl/reports/themeF/2005/05F10/}.

  Gilbert, Paul D. and Meijer, Erik (2006) Money and Credit Factors.
  Bank of Canada Working Paper 2006-3, 
  Available from 
  \url{http://www.bank-banque-canada.ca/en/res/wp/wp(y)_2006.html}.
}
\keyword{ package }
\keyword{ ts }

\seealso{
   \code{\link{estTSF.ML}}, 
   \code{\link[GPArotation:GPArotation-package]{GPArotation}}, 
   \code{\link[tframe:tframe-package]{tframe}}, 
   \code{\link[dse1:dse1-package]{dse1}}, 
   \code{\link[dse2:dse1-package]{dse2}} 
}
