% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arbitration-methods.r
\docType{methods}
\name{update_ade_meta}
\alias{update_ade_meta}
\alias{update_ade_meta,ADE-method}
\title{Updating the metalearning layer of an ADE model}
\usage{
update_ade_meta(object, newdata)

\S4method{update_ade_meta}{ADE}(object, newdata)
}
\arguments{
\item{object}{a \code{\link{ADE-class}} object.}

\item{newdata}{data used to update the meta models. This should be
the data used to initially train the meta-models (training set), together
with new observations (for example, validation set). Each meta model
is retrained using \code{newdata}.}
}
\description{
The \strong{update_ade_meta} function uses new information to
update the meta models of an \code{\link{ADE-class}} ensemble. As input
it receives a \code{\link{ADE-class}} model object class and a new dataset
for updating the weights of the base models in the ensemble.
This new data should have the same structure as the one used to build the
ensemble. Updating the base models of the ensemble is done using the \code{\link{update_base_models}}
function.
}
\examples{
\dontrun{
specs <- model_specs(
 learner = c("bm_svr", "bm_glm", "bm_mars"),
 learner_pars = NULL
)

data("water_consumption")
dataset <- embed_timeseries(water_consumption, 5)
train <- dataset[1:1000, ]
validation <- dataset[1001:1200, ]
test <- dataset[1201:1500, ]

model <- ADE(target ~., train, specs)

preds_val <- predict(model, validation)
model <- update_ade_meta(model, rbind.data.frame(train, validation))

preds_test <- predict(model, test)
}

}
\seealso{
\code{\link{ADE-class}} for building an ADE model;
\code{\link{update_weights}} for updating the weights of the ensemble (without
retraining the models); and \code{\link{update_base_models}} for updating the
base models of an ensemble.

Other updating models: \code{\link{update_ade}},
  \code{\link{update_weights}}
}
