% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd_nlVar.R
\name{fevd.nlVar}
\alias{fevd.nlVar}
\title{Forecast Error Variance Decomposition}
\usage{
\method{fevd}{nlVar}(x, n.ahead = 10, ...)
}
\arguments{
\item{x}{Object of class \sQuote{\code{VAR}} generated by
\command{lineVar()}, or an object of class \sQuote{\code{VECM}} generated by
\command{VECM()}}

\item{n.ahead}{Integer specifying the number of steps.}

\item{...}{Currently not used.}
}
\value{
A list with class attribute \sQuote{\code{varfevd}} of length
\code{K} holding the forecast error variances as matrices.
}
\description{
Use the \code{fevd} function from package \pkg{vars} to compute the forecast
error variance decomposition of a VAR(p) or VECM for \code{n.ahead} steps.
}
\details{
The function converts the VAR or VECM computed by package tsDyn into an
object of class \sQuote{\code{vec2var}}, on which then the
\code{\link[vars]{fevd}} method is applied. For details, see package
\pkg{vars}.
}
\examples{

data(zeroyld)
mod_vecm <- VECM(zeroyld, lag = 2)
fevd(mod_vecm, n.ahead = 5)

}
\references{
Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
University Press, Princeton.

Lutkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
Analysis}, Springer, New York.
}
\seealso{
\code{\link{plot}} for the plot method. \code{\link{lineVar}},
\code{\link{VECM}} for the models.
}
\author{
Bernhard Pfaff
}
\keyword{regression}
