% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_dist.R
\name{tsdist_vr}
\alias{tsdist_vr}
\title{van Rossum distance}
\usage{
tsdist_vr(ets1, ets2, tau = 1, sig_test = FALSE, reps = 100, sig_level = 0.01)
}
\arguments{
\item{ets1}{Event time series 1 (one means an event, or zero otherwise)}

\item{ets2}{Event time series 2 (one means an event, or zero otherwise)}

\item{tau}{Parameter for filtering function (See fmetric function from mmpp
package.)}

\item{sig_test}{Run a statistical test. Return 0 if significant or 1 otherwise.}

\item{reps}{Number of repetitions to construct the confidence interval}

\item{sig_level}{The significance level to test if correlation is significant.}
}
\value{
distance
}
\description{
This function compares the times which the events occur e.g., time indices
where the time series values are different than zero. Note that the intensity
does not matter but if there is an event or not. This function also performs
a statistical test using a shuffling approach to test significance. This
implementation uses the fmetric function from the mmpp package.
}
