% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pGARMA.R
\name{pGARMA}
\alias{pGARMA}
\title{Cumulative distribution function for the stationary GARMA distribution}
\usage{
pGARMA(
  x,
  cond = FALSE,
  mean = 0,
  errorvar = 1,
  ar = numeric(0),
  ma = numeric(0),
  log = FALSE
)
}
\arguments{
\item{x}{A vector or matrix of time-series values (if a matrix, each time-series should be one row of the matrix)}

\item{cond}{Either a single logical value ```FALSE``` or a logical vector with the same number of elements; as each time-series vector; each logical value indicates whether the density is conditional on the associated time-series value in ```x```.}

\item{mean}{The mean parameter}

\item{errorvar}{The error variance parameter}

\item{ar}{Vector of auto-regressive coefficients (all roots of AR characteristic polynomial must be outside the unit circle)}

\item{ma}{Vector of moving-average coefficients}

\item{log}{Logical; if ```TRUE``` the function returns the log-probability; if ```FALSE``` the function returns the probability

data(garma)
AR <- c(0.8, -0.2)
MA <- c(0.6,  0.3)

#Compute the cumulative probability of the GARMA output
(PROBS <- pGARMA(SERIES, ar = AR, ma = MA))}
}
\description{
This function computes the cumulative distribution function from the stationary Gaussian auto-regressive moving-average (GARMA) distribution.
The user specifies a vector ```x``` giving a single time-series vector, or a matrix ```x``` giving one time-series vector in each row, and the
function returns the vector of cumulative probabilities corresponding to the input time-series vectors.  By default the function generates from
the marginal GARMA distribution, but the user may give conditioning indicators in the ```cond``` vector to compute the conditional density where
some of the elements in the input vectors are conditioning values.
}
