% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcDstBLD}
\alias{calcDstBLD}
\title{Calculate the BLD between two trees}
\usage{
calcDstBLD(tree_1, tree_2, nrmlsd = FALSE, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree_1}{\code{TreeMan} object}

\item{tree_2}{\code{TreeMan} object}

\item{nrmlsd}{Boolean, should returned value be between 0 and 1? Default, FALSE.}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the branch length distance between two trees.
}
\details{
BLD is the Robinson-Foulds distance weighted by branch length. Instead of summing
the differences in partitions between the two trees, the metric takes the square root
of the squared difference in branch lengths. Parallelizable.
}
\examples{
library(treeman)
tree_1 <- randTree(10)
tree_2 <- randTree(10)
calcDstBLD(tree_1, tree_2)
}
\references{
Kuhner, M. K. and Felsenstein, J. (1994) Simulation comparison of phylogeny
algorithms under equal and unequal evolutionary rates. Molecular Biology and
Evolution, 11, 459-468.
}
\seealso{
\code{\link{calcDstTrp}}, \code{\link{calcDstRF}} 
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}
