% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsPrids}
\alias{getNdsPrids}
\title{Get pre-nodes for multiple nodes}
\usage{
getNdsPrids(tree, ids, ordrd = FALSE, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{ordrd}{logical, ensure returned prids are ordered ID to root}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return node ids for connecting \code{id} to root.
}
\details{
Returns a list, parallizable. The function will work faster
if \code{ordrd} is FALSE.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsPrids(tree, ids=tree['tips'])
}
\seealso{
\code{\link{getNdPrids}},
\code{\link{getNdPtids}}, 
\code{\link{getNdsPtids}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
