% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_heat.R
\name{prepare_feats}
\alias{prepare_feats}
\title{Prepares the feature dataframes for tiles.}
\usage{
prepare_feats(dat, disp_feats, feat_types, clust_feats, trans_type)
}
\arguments{
\item{dat}{Dataframe with samples from original dataset ordered according to
the clustering within each leaf node.}

\item{disp_feats}{Character vector specifying features to be displayed.}

\item{feat_types}{Named vector indicating the type of each features,
e.g., c(sex = 'factor', age = 'numeric').
If feature types are not supplied, infer from column type.}

\item{clust_feats}{Logical. If TRUE, performs cluster on the features.}

\item{trans_type}{Character string of 'normalize', 'scale' or 'none'.
If 'scale', subtract the mean and divide by the standard deviation.
If 'normalize', i.e., max-min normalize, subtract the min and divide by the max.
If 'none', no transformation is applied.
More information on what transformation to choose can be acquired here:
https://cran.rstudio.com/package=heatmaply/vignettes/heatmaply.html#data-transformation-scaling-normalize-and-percentize}
}
\value{
A list of two dataframes (continuous and categorical)
from the original dataset.
}
\description{
If R does not recognize a categorical feature (input from user) as factor,
converts to factor.
}
