% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traceplot.R
\name{traceplot}
\alias{traceplot}
\title{Trace the temporal development of response or correlation coefficients}
\usage{
traceplot(x, variables = NULL, facet = FALSE)
}
\arguments{
\item{x}{an object returned from a call to \code{dcc} with parameter
\code{dynamic} set to either "moving" or "evolving".}

\item{variables}{a character vector of variable names to be plotted; if NULL
(default), all variables will be traced}

\item{facet}{logical: shall the plot be splitted into facets for different
variables?}
}
\value{
an object of class "gg".
}
\description{
This is a plotting function that takes the output from a dynamic ("moving"
or "evolving") \code{dcc} run to trace the temporal development of all or
selected variables. The variables can be selected using their name, partial
matching is allowed.
}
\examples{
\dontrun{
dc_resp <- dcc(muc_spruce, muc_clim, 4:9, dynamic = "evolving")
traceplot(dc_resp, c("prec.curr.may", "prec.curr.jun"))
}
}
