% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gershunov.R
\name{g_test}
\alias{g_test}
\title{Gershunov test for spurious low-frequency modulations}
\usage{
g_test(x, boot = FALSE, ci = 0.05, sb = TRUE)
}
\arguments{
\item{x}{an object of class '"tc_dcc"' as returned from a call to
\code{\link{dcc}} with moving correlations enabled}

\item{boot}{\code{logical} shall the individual correlation be
bootstrapped?  (see details)}

\item{ci}{Significance level for testing, one of \code{c(0.01,
0.05, 0.1)}}

\item{sb}{\code{logical} shall a status bar be drawn?}
}
\value{
a \code{data.frame} with columns for variable
identification and logical flags for whether the low-frequency
modulation of the correlation of this variable with tree-growth is
higher than expected by chance, lower than expected by chance, or
can be considered as noise.
}
\description{
This function provides a test to decide whether low-frequency
modulations in the relationship between climate and tree-growth
are significantly stronger or weaker than could be expected by
chance.
}
\details{
This function is a multivariate extension of the test for
spurious low-frequency modulations for moving correlations of time
series as proposed by Gershunov et al. (2001). In short, 1000
simulations of random data sets are generated, where the climate
data is simulated as Gaussian noise, and the tree-data as linear
combinations of the climate parameters using the original
coefficients of the correlation function, and an error component
with a variance equal to the variance unexplained by the
individual parameters.
  
For each iteration, a moving correlation function is calculated
with exactly the same settings as the original model. The standard
deviation over the individual windows for each parameter is then
compared to the bootstrapped distribution of the standard
deviation of the simulated data to test for significantly higher
or lower low-frequency modulations.
}
\examples{
\dontrun{
dc_cor <- dcc(muc_spruce, muc_clim, 3:9, method = "cor", moving = TRUE)
g_test(dc_cor)
}
}
\references{
Gershunov, A., N. Schneider, and
T. Barnett. 2001. Low-frequency modulation of the ENSO-Indian
Monsoon rainfall relationship: Signal or noise? Journal of Climate
14:2486-2492.
}
\keyword{test}

