% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boundary_radius.R
\name{get_boundary_radius}
\alias{get_boundary_radius}
\title{Get the Boundary Radius for a Given Diameter at Breast Height}
\usage{
get_boundary_radius(
  dbh,
  unit = c("mm", "cm", "dm", "m"),
  couting_factor = 4,
  area = 10000
)
}
\arguments{
\item{dbh}{Diameter at breast height in millimeter.}

\item{unit}{The unit for the return value.}

\item{couting_factor}{The basal area factor used in counting the trees. For
tally trees in the German national forest inventory its value is 4 [m^2].}

\item{area}{The reference surface in [m^2].}
}
\value{
Minimum diameter at breast height in \code{units}.
}
\description{
The boundary radius is the maximum distance a tree with a given diameter at
breast height may be
away from the center of the plot to still be part of the sample.
}
\details{
\code{couting_factor} and \code{area} really don't have to be square
meters as long as they are in the same unit.
}
\examples{
# A diameter at breast height of 50.5 cm
get_boundary_radius(505, unit  = "m")
get_boundary_radius(1000, unit  = "cm")
}
\keyword{internal}
