% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling.R
\name{subwasserstein}
\alias{subwasserstein}
\title{Approximate Computation of Wasserstein Distances via Subsampling.}
\usage{
subwasserstein(source, target, S, K = 1, p = 1, costM = NULL,
  prob = TRUE, precompute = FALSE, method = "revsimplex")
}
\arguments{
\item{source}{The source measure has to be either a weight vector or an object
of one of the classes \code{"pgrid"}, \code{"wpp"} or \code{"pp"}.}

\item{target}{The target measure needs to be of the same type as the source measure.}

\item{S}{The sample size.}

\item{K}{The number of tries. Defaults to 1.}

\item{p}{The order of the Wasserstein metric (i.e. the power of the distances). Defaults to 1.}

\item{costM}{The cost matrix between the source and target measures. Ignored unless source
and target are weight vectors.}

\item{prob}{logical. Should the objects a, b be interpreted as probability measures, i.e. their
total mass be normalized to 1?}

\item{precompute}{logical. Should the cost matrix for the large problem be precomputed?}

\item{method}{A string with the name of the method used for optimal transport distance computation.
Options are "revsimplex", "shortsimplex" and "primaldual". Defaults to "revsimplex".}
}
\value{
The mean of the K values of the Wasserstein distances between
        the subsampled measures.
}
\description{
Samples \code{S} elements each of a source and a target measure and
computes the Wasserstein distance between the samples.
The mean distance out of \code{K} tries is returned.
}
\details{
For larger problems setting \code{precompute} to \code{TRUE} is not recommended.
}
\examples{
\dontrun{
subwasserstein(random64a, random64b, S=1000)
wasserstein(random64a, random64b)
}

}
\references{
M. Sommerfeld, J. Schrieber, Y. Zemel and A. Munk (2018)
            Optimal Transport: Fast Probabilistic Approximation with Exact Solvers
            preprint: \href{https://arxiv.org/abs/1802.05570}{arXiv:1802.05570}
}
\author{
Jörn Schrieber \email{joern.schrieber-1@mathematik.uni-goettingen.de}\cr
        Dominic Schuhmacher \email{dominic.schuhmacher@mathematik.uni-goettingen.de}
}
