% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibPlane.R
\name{calibPlane}
\alias{calibPlane}
\title{Calculates regression plane for external standard calibration.}
\usage{
calibPlane(plane, badpoint = NULL, plot = TRUE, lines = 13, theta = -30,
  phi = 40, xlab = "Species 1", ylab = "Species 2", zlab = "Signal",
  pch = 18, cex = 2)
}
\arguments{
\item{plane}{Data frame of numeric vectors named 'Conc', 'Conc.S' and
'Signal'. The vectors must contain the concentrations of
the main species (the one whose concentration in the
samples is to be known) and the secondary species (the
interferent), and the standard's signals, respectively.}

\item{badpoint}{Numeric vector with the points to be ignored in the
regresion. This allows the easy elimination of outliers
without losing the stored measurement information.}

\item{plot}{Logical. If \code{TRUE}, the default, the calibration data
is plotted.}

\item{lines}{Number of lines to use in the mesh of the plane in the plot.}

\item{theta}{Azimuthal angle at which the plane is visualized.}

\item{phi}{Altitude angle  at which the plane is visualized.}

\item{xlab}{Label for X axis (main species concentration).}

\item{ylab}{Label for Y axis (secondary species concentration).}

\item{zlab}{Label for Z axis (response).}

\item{pch}{Plotting symbols available in R.}

\item{cex}{The size of pch symbols.}
}
\value{
Model of the calibration plane
}
\description{
A bivariated regression plane for external standard calibration is
calculated to later convert signals into concentration values.
It differs from \code{\link{calibCurve}} in the number of explanatory
variables, 2 in this case. This function is useful when some
interference effect is being considered such as the magnification of
the interest species signal due to the presence of another (known) species
in the same sample.
}
\details{
A linear method (i.e \code{lm()}) is applied to obtain the
regression equation. The user must verify model assumptions
such as normal distribution of residuals.
}
\examples{
  data(planelithium)
  planeModel <- calibPlane(plane = planelithium)
  summary(planeModel$model)
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
