% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssAny.R
\name{xpssAny}
\alias{xpssAny}
\title{Selecting cases by condition}
\usage{
xpssAny(x, st = NULL, nd = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{st}{atomic numeric or atomic character with a single value to search for OR variable where to search in.}

\item{nd}{atomic numeric or atomic character, respecetively as numeric vector or character vector with values to search for OR variables to search in.}
}
\value{
A logical vector with matched conditions.
}
\description{
xpssAny can be perceived as a wrapper function for \code{\link{\%in\%}} applicable on more than one variable.
}
\examples{
data(fromXPSS)

xpssAny(fromXPSS, 310, c("V7_1", "V7_2"))

xpssAny(fromXPSS, "V7_1", c(310,320,170))

xpssAny(fromXPSS, "Audi", c("V1", "V7_2"))

xpssAny(fromXPSS, "V1", c("Audi"))
}
\author{
Andreas Wygrabek
}
\seealso{
\code{\link{xpssCount}} \code{\link{\%in\%}} \code{\link{is.element}}
}

