% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uh.R
\name{uh}
\alias{uh}
\alias{uh.default}
\alias{uh.units}
\alias{uh.stars}
\alias{uh.transfR}
\title{Unit hydrograph estimation}
\usage{
uh(hl, ...)

\method{uh}{default}(hl, uc, deltat, ...)

\method{uh}{units}(hl, uc, deltat, ...)

\method{uh}{stars}(hl, ...)

\method{uh}{transfR}(hl, verbose = TRUE, ...)
}
\arguments{
\item{hl}{hydraulic length of class \code{stars}, \code{matrix}, \code{vector} or \code{transfR}.
If no unit is provided, \code{hl} is assumed to be in [m].}

\item{...}{further arguments passed to or from other methods}

\item{uc}{streamflow velocity. If no unit is provided, \code{uc} is assumed to be in [m/s].}

\item{deltat}{time step of the time series. If no unit is provided, \code{deltat} is assumed to be in [min].}

\item{verbose}{boolean indicating if information messages should be written to the console}
}
\value{
A data.frame with vectors of class units, or if \code{hl} is a transfR object,
the same transfR object incremented by the "uh" attribute.
}
\description{
Estimate the unit hydrograph from a sample of hydraulic lengths and a streamflow velocity.
}
\details{
The function estimates the unit hydrograph from geomorphometric information.
A travel time to the outlet is estimated by assuming an average streamflow velocity (\code{uc})
within the river network and  by applying \code{uc} over the sample of hydraulic lengths (\code{hl}).
The unit hydrograph is the probability distribution of this travel time to the outlet
given at each time step (\code{deltat}).
}
\examples{
data(Oudon)
uh1 <- uh(hl=Oudon$hl[[1]], uc=units::set_units(0.5,"m/s"),
deltat=units::set_units(1,"h"))
plot(units::set_units(uh1$max_time,"h"), cumsum(uh1$prob), type = "b",
xlab = "Travel~time", ylab = "Probability~of~non-exceedance")

object <- as_transfr(st=Oudon$obs,hl=Oudon$hl)
object <- velocity(object)
object <- uh(object)
plot(object,i=1,attribute=c("uh"))
}
