% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmcc.R
\name{pmcc}
\alias{pmcc}
\title{Product-Moment Correlation Coefficient}
\usage{
pmcc(trun, obs, a = 0, trans = "linear")
}
\arguments{
\item{trun}{left truncation time satisfying \code{trun} <= \code{obs}.}

\item{obs}{observed failure time, must be the same length as \code{trun}, might be right-censored.}

\item{a}{a numeric transformation parameter. The default value is 0, which applies no transformation.
This parameter must be greater than \code{-1}.
See \code{?tranSurvfit} for the transformation model structure.}

\item{trans}{a character string specifying the transformation structure. The following are permitted:
\describe{
  \item{linear}{linear transformation structure,}
  \item{log}{log-linear transformation structure,}
  \item{exp}{exponential transformation structure.}
}}
}
\description{
\code{pmcc} computes the conditional product-moment correlation coefficient proposed by Chen et al. (1996).
The conditional product-moment correlation coefficient uses only the uncensored events.
}
\examples{
data(channing, package = "boot")
chan <- subset(channing, sex == "Male" & entry < exit & cens == 1)
with(chan, pmcc(entry, exit)) ## cannot handle right censored data
}
\seealso{
\code{\link{trSurvfit}}
}
