% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.tramME}
\alias{vcov.tramME}
\title{Calculate the variance-covariance matrix of the parameters}
\usage{
\method{vcov}{tramME}(
  object,
  parm = NULL,
  pargroup = c("all", "fixef", "shift", "baseline", "ranef", "smooth"),
  pmatch = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted tramME object.}

\item{parm}{The names of the parameters of interest. See in details.}

\item{pargroup}{The name of the parameter group to return:
\itemize{
  \item all: All parameters.
  \item fixef: Fixed effects parameters.
  \item shift: Shift parameters.
  \item baseline: Parameters of the baseline transformation function.
  \item ranef: Variance components parameters.
  \item smooth: Paramaters that belong to the smooth shift terms
    (both FE and smoothing parameters).
}}

\item{pmatch}{Logical. If \code{TRUE}, partial name matching is allowed.}

\item{...}{Optional arguments passed to \code{vcov.tramTMB}}
}
\value{
A numeric covariance matrix.
}
\description{
Extracts the covariance matrix of the selected parameters. The returned values
are on the same scale as the estimated parameter values, i.e. the standard
deviations of the random effect terms are on log scale.
}
\details{
Access to variances and covariances of penalized parameters is currently
provided by the \code{parm} argument. Parameter names must be consistent
with names in \code{object$param}.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy, order = 10)
vcov(fit)
vcov(fit, pargroup = "ranef")
vcov(fit, pargroup = "baseline")
vcov(fit, parm = "Reaction") ## same as previous
}
