% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramTMB.R
\name{optim_control}
\alias{optim_control}
\title{Set up and control optimization parameters}
\usage{
optim_control(
  method = c("nlminb", "BFGS", "CG", "L-BFGS-B"),
  scale = TRUE,
  trace = FALSE,
  ntry = 5,
  ok_warnings = "NA/NaN function evaluation",
  ...
)
}
\arguments{
\item{method}{Optimization procedure.}

\item{scale}{Logical; if \code{TRUE} rescale the fixed effects design matrix to improve
convergence.}

\item{trace}{Logical; print trace of the optimization.}

\item{ntry}{Number of restarts with new random initialization if optimization
fails to converge.}

\item{ok_warnings}{Control for what warnings will be reported during
optimization. If \code{TRUE}, no warnings will be reported, if
\code{FALSE} all warnings are displayed. In case of a character vector,
the matching warnings are treated as unimportant, and not reported. See also Notes.}

\item{...}{Optional arguments passed to \code{\link[alabama]{auglag}},
\code{\link[stats]{nlminb}} or \code{\link[stats]{optim}} as a list of control
parameters.}
}
\description{
Set up and control optimization parameters
}
\note{
Irrespective of the value of the \code{ok_warnings} argument, all
  warnings are collected in the \code{opt$warnings} element of the
  \code{tramME} object.
}
