% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ranef.tramME}
\alias{ranef.tramME}
\alias{ranef}
\title{Extract the conditional modes and conditional variances of random effects}
\usage{
\method{ranef}{tramME}(
  object,
  param = c(coef(object, with_baseline = TRUE, fixed = FALSE), varcov(object, as.theta
    = TRUE)),
  newdata = NULL,
  condVar = FALSE,
  raw = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{param}{An optional vector of parameter values in the structure
(beta, theta).}

\item{newdata}{An optional \code{data.frame} of new observations for which the
new random effects values are predicted.}

\item{condVar}{If \code{TRUE}, include the conditional variances as attributes.}

\item{raw}{Return the unformatted RE estimates as fitted by the model.}

\item{...}{Optional arguments (for consistency with generic)}
}
\value{
Depending on the value of raw, either a numeric vector or a
  \code{ranef.tramME} object which contains the conditional mode and variance
  estimates by grouping factors.
}
\description{
Extract the conditional modes and conditional variances of random effects
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy, order = 5)
ranef(fit, raw = TRUE)
ranef(fit)
}
