% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{TrajsStatsReplaceNAs}
\alias{TrajsStatsReplaceNAs}
\title{Replace NAs in a data frame}
\usage{
TrajsStatsReplaceNAs(df, column, replacementValue = mean(df[, column],
  na.rm = TRUE), flagColumn = NULL)
}
\arguments{
\item{df}{Data frame to be adjusted.}

\item{column}{Name or index of the column to be adjusted.}

\item{replacementValue}{Numeric value to use instead of NA.}

\item{flagColumn}{If not NULL, specifies the name of a new column to be added
to the data frame, with value 0 for non-NA rows, 1 for NA rows. The column
is added regardless of whether there are any NAs in the data.}
}
\value{
A copy of \code{df} with NAs replaced in \code{column}.
}
\description{
Replaces NAs in a single column of a data frame with an imputed uninformative
numeric replacement value, so that a principal component analysis can be
applied without discarding data. Optionally adds a new "flag" column which
contains \code{1} for each row which originally contained NA, otherwise
\code{0}.
}
\examples{
df <- data.frame(x = c(1, 2, 3), y = c(NA, 5, 6), z = c(NA, NA, 9))
# Eliminate NAs in y, add a flag column, ignore other NAs
df <- TrajsStatsReplaceNAs(df, "y", flagColumn = "y.was.NA")
print(df)

}
\seealso{
\code{\link[stats]{prcomp}}
}
