% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffmpeg.R
\name{vid.to.images2}
\alias{vid.to.images2}
\title{Extracts images from a video file with ffmpeg}
\usage{
vid.to.images2(
  vid.path = NULL,
  out.dir = NULL,
  overwrite = FALSE,
  filt = NULL,
  codec = NULL,
  silent = TRUE
)
}
\arguments{
\item{vid.path}{character; path of video file to be processed.}

\item{out.dir}{character; directory path in which to store images.}

\item{overwrite}{logical; should path described by 'out.dir' be overwritten if it exhists.}

\item{filt}{character; video filter that should be applied to ffmpeg operation. See \url{https://ffmpeg.org/ffmpeg-filters.html}}

\item{codec}{character; video codec to apply in ffmpeg operation}

\item{silent}{logical; should output of \code{system} call for ffmpeg operation be suppressed.}
}
\value{
Extracts all the images of the video and saves them to an "images" directory with appended number sequence
}
\description{
Extract images from video file using ffmpegs flexible video filters and codecs
}
\details{
Particularly useful for resizing images
}
\examples{

#make a video with animation package
\donttest{
fun <- function(){
y <- sin(1:50)
x <- 1:50
for(i in 1:50) {
  plot(x[i],y[i],col="red",xlim=c(0,50),ylim=range(y))
  animation::ani.pause()
  }
}
animation::saveVideo(fun(),video.name=paste0(tempdir(),"/wave.mp4"),interval = 0.2)

#reduce the image images to 200 px wide maintaining aspect ratio
#notice the spaces at the beginning/end of string
filt.red <- " -vf scale=200:-1 "
c <- " -c:v libx264 "
dir.create(paste0(tempdir(),"/images"))
vid.to.images2(vid.path=paste0(tempdir(),"/wave.mp4"),
out.dir=paste0(tempdir(),"/images"),filt=filt.red,codec=NULL)

#see the images in the "images" directory
list.files( paste0(tempdir(),"/images"))

#clean up
unlink(paste0(tempdir(),"/images"),recursive=TRUE)
}
}
\seealso{
\code{\link{images.to.video}}
}
