% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_plot.R
\name{plot.trackeRdata}
\alias{plot.trackeRdata}
\title{Plot training sessions in form of trackeRdata objects}
\usage{
\method{plot}{trackeRdata}(x, session = NULL, what = c("pace",
  "heart_rate"), threshold = TRUE, smooth = FALSE, trend = TRUE,
  dates = TRUE, unit_reference_sport = NULL, moving_threshold = NULL,
  ...)
}
\arguments{
\item{x}{An object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be plotted,
defaults to all sessions.}

\item{what}{Which variables should be plotted? A vector with at least one of \code{"latitude"}, \code{"longitude"}, \code{"altitude"}, \code{"distance"}, \code{"heart_rate"}, \code{"speed"}, \code{"cadence_running"}, \code{"cadence_cycling"}, \code{"power"}, \code{"temperature"}, \code{"pace"}, \code{"cumulative_elevation_gain"}. Default is \code{c("pace", "heart_rate")}.}

\item{threshold}{Logical. Should thresholds be applied?}

\item{smooth}{Logical. Should the data be smoothed?}

\item{trend}{Logical. Should a smooth trend be plotted?}

\item{dates}{Logical. Should the date of the session be used in the
panel header?}

\item{unit_reference_sport}{The sport to inherit units from
(default is taken to be the most frequent sport in
\code{object}).}

\item{moving_threshold}{A named vector of 3 speeds to be used for
thresholding pace, given in the unit of the speed measurements
in \code{object}. If \code{NULL} (default), the speeds are
taken to be \code{c(cycling = 2, running = 1, swimming =
0.5)}. See Details.}

\item{...}{Further arguments to be passed to
\code{\link{threshold}} and
\code{\link{smootherControl.trackeRdata}}.}
}
\description{
Plot training sessions in form of trackeRdata objects
}
\details{
Note that a threshold is always applied to the pace. This (upper)
threshold corresponds to a speed of 1.4 meters per second, the
preferred walking speed of humans. The lower threshold is 0.

The units for the variables match those of the sport specified by
\code{unit_reference_sport}.
}
\examples{
\dontrun{
data('runs', package = 'trackeR')
## plot heart rate and pace for the first 3 sessions
plot(runs, session = 1:3)
## plot raw speed data for session 4
plot(runs, session = 4, what = "speed", threshold = FALSE, smooth = FALSE)
## threshold speed variable
plot(runs, session = 4, what = "speed", threshold = TRUE, smooth = FALSE,
    variable = "speed", lower = 0, upper = 10)
## and smooth (thresholding with default values)
plot(runs, session = 4, what = "speed", threshold = TRUE,
    smooth = TRUE, width = 15, parallel = FALSE)
#'
## Speed and elevation gain
plot(runs, session = 2:10, what = c("speed", "cumulative_elevation_gain"), trend = FALSE)
}

}
\seealso{
trackeRdata
}
